import React from 'react';
import Head from 'next/head';
import { ConfigProvider } from 'antd';
import App, { Container } from 'next/app';
import vi_VN from 'antd/lib/locale-provider/vi_VN';

export default class MainApp extends App {
  render() {
    const { Component, pageProps, store, router } = this.props;
    return (
      <Container>
        <Head>
            <meta charSet="UTF-8" />
            <title>Mext React App Base</title>
            <meta name="viewport" content="width=device-width, initial-scale=1.0" />
						<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/antd/3.14.1/antd.min.css" />
        </Head>
        <ConfigProvider locale={vi_VN}>
          <Component {...pageProps} />
        </ConfigProvider>
      </Container>
    )
  }
}
