import React from 'react';
import MainLayout from '../layouts';

/*
 * Higher order component that passes `getInitialProps` through
 * to the child component
 */
export const Main = Child => {
  return class Higher extends React.Component {
    static getInitialProps = async (ctx) => {
      const pageProps = Child.getInitialProps ? await Child.getInitialProps(ctx) : {};

      return {
        ...pageProps
      }
    }

    render() {
      return (
        <MainLayout>
          <Child {...this.props} />
        </MainLayout>
      );
    }
  }
}
