import React from "react";
import { Layout, Menu, Breadcrumb } from 'antd';
const { Header, Content, Footer } = Layout;
import { withRouter } from 'next/router';
import Link from 'next/link';

@withRouter
export default class MainLayout extends React.Component {
  constructor(props){
    super(props);
    this.state = this.state ? {
      ...this.state,
      path: props.router.pathname,
      collapsed: false
    }:{
      path: props.router.pathname,
      collapsed: false
    }
  }

  render(){
    return(
      <Layout className="layout">
        <Header>
          <Menu
            theme="dark"
            mode="horizontal"
            defaultSelectedKeys={[this.state.path]}
            onSelect={this.onSelect}
            style={{ lineHeight: '64px' }}
          >
            <Menu.Item key="/"><Link href="/"><a className="nav-text">Dashboard</a></Link></Menu.Item>
          </Menu>
        </Header>
        <Content style={{ padding: '0 0' }}>
          <div style={{ background: '#fff', padding: 0, minHeight: 'calc(100vh - 69px - 64px)', margin: 0 }}>
            { this.props.children }
          </div>
        </Content>
        <Footer style={{ textAlign: 'center' }}>Goong copyright 2019 - Created by Goong Team</Footer>
      </Layout>
    ); 
  }
}
