import React from 'react';
import Head from 'next/head';
import Link from 'next/link';
import { Tag, Button } from 'antd';

export default class Error extends React.Component {
  static getInitialProps({ res, err }) {
    const statusCode = res ? res.statusCode : err ? err.statusCode : null;
    const errorMsg = res ? res.message : err ? err.message : null;
    return { statusCode, errorMsg };
  }

  render() {
    return (
      <div style={{ display: 'flex', height: '100vh', alignItems: 'center', justifyContent: 'center' }}>
        <Head>
          <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/antd/3.13.2/antd.min.css" />
          <title>Oops page</title>
        </Head>
        {this.props.statusCode ? (<div style={{textAlign: "center"}}>
            <div style={{display: "flex", alignItems: "center", justifyContent: "center"}}>
              <Tag color="#f50" style={{fontSize: 35, lineHeight: "50px", height: 50}}>{this.props.statusCode}</Tag>
              <div style={{borderRight: "1px", borderColor: "#888", textAlign: "left"}}>
                {this.props.errorMsg || "An error occurred on server!"}
              </div>
            </div>
        	</div>) : (
          <div>
            <Tag color="#f50">Unknown</Tag>
            <span> | {this.props.errorMsg || "An error occurred!"}</span>
          </div>
        )}
      </div>
    );
  }
}
